import React from 'react';
import cn from 'classnames';
import useStyles from './styles';

type Props = {
    imageIcon: Element,
    badgeIcon: Element,
    unitContainerClasses: {
        [key: string]: string
    },
    imageClasses: {
        [key: string]: string
    },
    badgeClasses: {
        [key: string]: string
    }
};

function UnitImageWithBadge({
    imageIcon,
    badgeIcon,
    unitContainerClasses,
    imageClasses,
    badgeClasses
}: Props) {
    const classes = useStyles();
    return (
        <div className={cn(classes.imageContainer, unitContainerClasses)}>
            <img
                className={cn(classes.unitIcon, imageClasses)}
                src={imageIcon}
                alt="Device icon"
            />
            {badgeIcon && (
                <img
                    className={cn(classes.badgeImage, badgeClasses)}
                    src={badgeIcon}
                    alt="Badge icon"
                />
            )}
        </div>
    );
}

export default UnitImageWithBadge;
